// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityAnomaly.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntityAnomaly.h"
#include "EntityPlayer.h"
#include "Level.h"
#include "Game.h"




EntityAnomaly::EntityAnomaly() :
  m_AttackDelay( 0.0f ),
  m_Attacked( false )
{

}



EntityAnomaly::~EntityAnomaly() 
{
}



void EntityAnomaly::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_INIT:
      if ( m_ExtraData == 1 )
      {
        m_Attacked = true;
      }
      break;
    case EE_HURT:
      m_Attacked = true;
      break;
    case EE_KILLED:
      // done, clear the alarm
      m_pLevel->m_pGame->OnGameEvent( Dobbs::GE_STOP_ALARM_ANOMALY );
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



void EntityAnomaly::UpdateTimed( Level& aLevel, float ElapsedTime )
{

  Entity::UpdateTimed( aLevel, ElapsedTime );

  if ( m_Attacked )
  {
    m_AttackDelay += ElapsedTime;
    if ( m_AttackDelay >= 0.75f )
    {
      m_AttackDelay -= 0.75f;
      if ( m_pLevel->m_pPlayer )
      {
        Entity*   pShot = m_pLevel->SpawnEntity( Dobbs::ENTITY_TYPE_SHOT, 0, m_X, m_Y );

        int   DX = m_pLevel->m_pPlayer->GetX() - m_X;
        int   DY = m_pLevel->m_pPlayer->GetY() - m_Y;

        int   Length = (int)sqrtf( (float)( DX * DX + DY * DY ) );

        if ( Length > 0 )
        {
          pShot->SetVelX( 100.0f * DX / Length );
          pShot->SetVelY( 100.0f * DY / Length );
        }
      }
    }
  }

}